#ifndef ElectronicLoad_h
#define ElectronicLoad_h

#include "Feature.h"
#include "ScpiInputInstrument.h"

class ElectronicLoad : public ScpiInputInstrument,
                       public SaveRecall {
public:
    enum {
        CHAN = 2000,
        CHAN_MAX,
        CHAN_MIN,
        CURR,
        CURR_MAX,
        CURR_MIN,
        CURR_SLEW,
        CURR_SLEW_MAX,
        CURR_SLEW_MIN,
        CURR_TLEV,
        CURR_TLEV_MAX,
        CURR_TLEV_MIN,
        CURR_TRIG,
        CURR_TRIG_MAX,
        CURR_TRIG_MIN,
        CURR_RANG,
        CURR_RANG_MAX,
        CURR_RANG_MIN,
        MEAS_CURRENT,
        MEAS_POWER,
        MEAS_VOLTAGE,
        MODE_CURRENT,
        MODE_RESISTANCE,
        MODE_VOLTAGE,
        REG_STAT_CHAN,
        REG_STAT_CHAN_COND,
        REG_STAT_CHAN_ENAB,
        REG_STAT_CSUM,
        REG_STAT_CSUM_ENAB,
        RES,
        RES_MAX,
        RES_MIN,
        RES_TLEV,
        RES_TLEV_MAX,
        RES_TLEV_MIN,
        RES_TRIG,
        RES_TRIG_MAX,
        RES_TRIG_MIN,
        RES_RANG,
        RES_RANG_MAX,
        RES_RANG_MIN,
        TRAN_MODE_CONTINUOUS,
        TRAN_MODE_PULSE,
        TRAN_MODE_TOGGLE,
        TRIG_SOUR_BUS,
        TRIG_SOUR_EXTERNAL,
        TRIG_SOUR_HOLD,
        TRIG_SOUR_LINE,
        TRIG_SOUR_TIMER,
        VOLT,
        VOLT_MAX,
        VOLT_MIN,
        VOLT_TLEV,
        VOLT_TLEV_MAX,
        VOLT_TLEV_MIN,
        VOLT_TRIG,
        VOLT_TRIG_MAX,
        VOLT_TRIG_MIN,
        VOLT_SLEW,
        VOLT_SLEW_MAX,
        VOLT_SLEW_MIN
    };

    virtual void configureContinuousTransient(const Real64 &, const Real64 &, const Int32 &, const Real64 &, const Real64 &);
    virtual void configureInput(const Int32 &, const Real64 &);
    virtual void configureParallelLoads(const Int32 &, const AInt32 &, const Real64 &, const Int32 &, const Real64 &, const Real64 &, const Boolean &, const Int32 &, const Real64 &, const Real64 &);
    virtual void configureTrigger(const Int32 &, const Int32 &, const Real64 &, const Real64 &);
    virtual void configureTriggeredTransient(const Int32 &, const Int32 &, const Real64 &, const Int32 &, const Real64 &, const Real64 &);
    virtual void getChannel(const Int32 &, ViPInt32);
    virtual void getCurrent(const Int32 &, ViPReal64);
    virtual void getCurrentRange(const Int32 &, ViPReal64);
    virtual void getRegister(const Int32 &, ViPInt32);
    virtual void getResistance(const Int32 &, ViPReal64);
    virtual void getResistanceRange(const Int32 &, ViPReal64);
    virtual void getVoltage(const Int32 &, ViPReal64);
    virtual void measure(const Int32 &, ViPReal64);
    virtual void setChannel(const Int32 &);
    virtual void setCurrent(const Int32 &, const Real64 &);
    virtual void setCurrentProtection(const Boolean &, const Real64 &, const Real64 &);
    virtual void setCurrentRange(const Int32 &, const Real64 &);
    virtual void setInputShort(const Boolean &);
    virtual void setMode(const Int32 &);
    virtual void setPort(const Boolean &);
    virtual void setRegister(const Int32 &, const Int32 &);
    virtual void setResistance(const Int32 &, const Real64 &);
    virtual void setResistanceRange(const Int32 &, const Real64 &);
    virtual void setTransient(const Boolean &, const Int32 &, const Real64 &, const Real64 &);
    virtual void setTrigger(const Int32 &, const Real64 &);
    virtual void setVoltage(const Int32 &, const Real64 &);

protected:
    bool m_AreMultipleChannelsSupported;

    virtual void checkLocation(const Int32 &);
    virtual void commandComplete() { ScpiInputInstrument::commandComplete(); }
    virtual void internalInit(const std::string &);

private:
    virtual void checkLanguage() {}
    virtual bool isValidModel(const std::string &) const;
    void popChannel() { setChannel(m_Channel); }
    void pushChannel() { getChannel(CHAN, &m_Channel); }

    ViInt32 m_Channel;
};

inline
void ElectronicLoad::checkLocation(const Int32 &location) {
    checkRange(location, 0, 6);
}

#endif